(function() {
  define(['Backbone', 'moment'], function(Backbone, Moment) {
    var TimeModel;
    return TimeModel = class TimeModel extends Backbone.Model {
      initialize() {}

      //console.log "Model Time initialized"
      get_time_string_from_float(dayStartsAt, usesAMPM, timeFloat) {
        var amPm, hours, hrs, intHour, minutes;
        hours = parseFloat(timeFloat) + parseFloat(dayStartsAt);
        minutes = Math.floor((hours % 1) * 60);
        intHour = Math.floor(hours);
        amPm = ' AM';
        if (usesAMPM === 1) {
          if (intHour >= 12 && intHour < 24) {
            amPm = ' PM';
          }
          if (intHour > 24) {
            hrs = intHour - 24;
          } else if (intHour > 12) {
            hrs = intHour - 12;
          } else if (intHour === 12 || intHour === 24) {
            hrs = 12;
          } else {
            hrs = String(intHour);
          }
          if (hrs < 10) {
            hrs = String(hrs);
          }
          if (minutes < 10) {
            minutes = '0' + String(minutes);
          }
          return hrs + ':' + minutes + amPm;
        } else {
          if (intHour >= 24) {
            hrs = intHour - 24;
          } else {
            hrs = intHour;
          }
          if (hrs < 10) {
            hrs = String(hrs);
          }
          if (minutes < 10) {
            minutes = '0' + String(minutes);
          }
          return hrs + ':' + minutes;
        }
      }

      get_float_from_time_string(dayStartsAt, timeString) {
        var arrTime, aux, intHour, intMinutes, val;
        arrTime = timeString.split(':');
        intHour = parseInt(arrTime[0], 10);
        if (_.indexOf(arrTime[1], 'M') !== -1) {
          aux = arrTime[1].split(' ');
          if (aux[1] === 'PM') {
            intHour += 12;
          }
        }
        intMinutes = parseInt(arrTime[1], 10);
        val = parseFloat(intHour + (intMinutes / 60.0) - dayStartsAt);
        if (val < 0 && val !== -dayStartsAt) {
          val += 24;
        }
        return val;
      }

    };
  });

}).call(this);
